package nemosofts.notes.app.utils;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.view.WindowManager;

import nemosofts.notes.app.constant.Constant;


public class IfSupported {

    private static final String TAG = "IfSupported";

    private IfSupported() {
        throw new IllegalStateException("Utility class");
    }

    public static void isRTL(Activity activity) {
        if (activity == null) {
            ApplicationUtil.log(TAG, "Activity context is null in isRTL");
            return;
        }
        try {
            if (Boolean.TRUE.equals(Constant.itemApp.getRTL())) {
                Window window = activity.getWindow();
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
                    WindowInsetsController insetsController = window.getInsetsController();
                    if (insetsController != null) {
                        insetsController.setSystemBarsBehavior(WindowInsetsController.BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE);
                        insetsController.hide(WindowInsets.Type.systemBars());
                    }
                }
                window.getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
            }
        } catch (Exception e) {
            ApplicationUtil.log(TAG, "Failed to apply RTL layout direction", e);
        }
    }

    public static void isScreenshot(Activity mContext) {
        if (mContext == null) {
            ApplicationUtil.log(TAG, "Activity context is null isScreenshot");
            return;
        }
        try {
            if (Boolean.TRUE.equals(Constant.itemApp.getScreenshot())) {
                Window window = mContext.getWindow();
                window.setFlags(WindowManager.LayoutParams.FLAG_SECURE, WindowManager.LayoutParams.FLAG_SECURE);
            }
        } catch (Exception e) {
            ApplicationUtil.log(TAG, "Failed to isScreenshot", e);
        }
    }

    public static void keepScreenOn(Activity mContext) {
        if (mContext == null) {
            ApplicationUtil.log(TAG, "Activity context is null keepScreenOn");
            return;
        }
        try {
            Window window = mContext.getWindow();
            window.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        } catch (Exception e) {
            ApplicationUtil.log(TAG, "Failed to keep screen on", e);
        }
    }
}
